﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace 電子文書回覧監視ツール
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            Form2 開始画面 = new Form2(); //追加した行
            開始画面.ShowDialog();        //追加した行
            contingency();
            Application.Run(form1= new Form1());
        }
        static Form1 form1;

        /// <summary>
        /// 例外補足登録ルーチン／イベントルーチン
        /// </summary>
        static void contingency() {
            Application.ThreadException += new System.Threading.ThreadExceptionEventHandler(threadException);
            System.Threading.Thread.GetDomain().UnhandledException += new UnhandledExceptionEventHandler(unhandledException);
        }

        public static void threadException(object sender, System.Threading.ThreadExceptionEventArgs e) {
            Exception ex = e.Exception;
            エラー処理(ex);
            Application.Exit();
        }

        public static void unhandledException(object sendr, UnhandledExceptionEventArgs e) {
            
            
            Exception ex = e.ExceptionObject as Exception;
            エラー処理(ex);
        }

        private static void エラー処理(Exception ex) {
            MessageBox.Show(Form.ActiveForm, "エラーが発生したのでプログラムを終了します。エラーログをデスクトップに記録します。", "監視ツール");

            string deskTop = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            System.IO.StreamWriter istrm = new System.IO.StreamWriter(deskTop + "\\監視ツールエラーログ.txt", false, System.Text.Encoding.GetEncoding("Shift_JIS"));
            istrm.WriteLine("監視ツール version " + form1.version);
            istrm.WriteLine("");
            istrm.WriteLine(ex.Message);
            istrm.WriteLine("");
            istrm.WriteLine(ex.StackTrace);
            istrm.Close();
            
        }
    }

}